﻿/********************************************************************/
/*                                                                  */
/* ADOBE SYSTEMS INCORPORATED                                       */
/* Copyright 1986 - 2010 Adobe Systems Incorporated                 */
/* All Rights Reserved                                              */
/*                                                                  */
/* NOTICE:  Adobe permits you to use, modify, and distribute this   */
/* file in accordance with the terms of the Adobe license agreement */
/* accompanying it.  If you have received this file from a source   */
/* other than Adobe, then your use, modification, or distribution   */
/* of it requires the prior written permission of Adobe.            */
/*                                                                  */
/********************************************************************/
/*
 * Program Name:                                                     
 *    << FM_Outputs_Conditional_Text.jsx  >>                                                    
 *                                                                   
 * General Description:                                              
 *    Book to Multiple PDF -> for generating Multiple PDF outputs on the basis of Conditional Text 
 *                                                                   
 *********************************************************************/      


var InputFile= ""; /* Give the full filepath of the Book here - this book should have conditional text with the names - Comment / Red / Blue / Green */

var ShowList = new Array()
var HideList = new Array()

/*  Output1: Show / Hide Conditions list here */
 ShowList[0] = new Array("Comment", "Red"); 
 HideList[0] = new Array("Blue", "Green");
 
/*  Output2: Show / Hide Conditions list here */
 ShowList[1] = new Array("Blue", "Green");
 HideList[1] = new Array("Red", "Comment");

/*  Define the list of Output file Names here. This would get appended to the original Book*/
var OutPutFiles = new Array("_Comment_Red.pdf", "_Blue_Green.pdf");  

for (var output_no=0; output_no<OutPutFiles.length; output_no++)   /*  Optimize possible here - file needs to be opened once - the ShowHide needs to be shifted from OpenBookFiles */
{
    /*  The Book on which Conditional Text  be applied before saving to PDF */
    FileSource = OpenBook(InputFile); 
            
    /*Apply Conditions to each document in OpenBookFiles function */
    OpenBookFiles(FileSource)

    /*  The Output Book PDF on which Conditional Text  is applied before saving to PDF  */
    SavePdf(FileSource,InputFile + OutPutFiles[output_no]); 

    /*  Close All Files */
    CloseAll()
}

function ShowHide(FileId, CondName, showOrHide)
{
     CondFmtId = FileId.GetNamedCondFmt (CondName)
    if (showOrHide) /* If 1 then show else hide*/
        CondFmtId.CondFmtIsShown = 1 
    else
        CondFmtId.CondFmtIsShown = 0
     FileId.ShowAll = 0  /* Setting it to ShowAll to apply the Condtional Text property*/
}
 
function OpenBook(filename) 
{
    openProp = GetOpenDefaultParams()

    i=GetPropIndex(openProp,Constants.FS_FileIsOldVersion)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_FontChangedMetric)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_FontNotFoundInCatalog)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_FontNotFoundInDoc)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_LanguageNotAvailable)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_LockCantBeReset)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_UpdateTextReferences)
    openProp[i].propVal.ival=Constants.FV_DoNo
    i=GetPropIndex(openProp,Constants.FS_UpdateXRefs)
    openProp[i].propVal.ival=Constants.FV_DoNo
    i=GetPropIndex(openProp,Constants.FS_UseAutoSaveFile)
    openProp[i].propVal.ival=Constants.FV_DoNo
    i=GetPropIndex(openProp,Constants.FS_UseRecoverFile)
    openProp[i].propVal.ival=Constants.FV_DoNo
    i=GetPropIndex(openProp,Constants.FS_AlertUserAboutFailure)
    openProp[i].propVal.ival=false
    i=GetPropIndex(openProp,Constants.FS_BeefyDoc)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_FileIsInUse) 
    openProp[i].propVal.ival=Constants.FV_ResetLockAndContinue
    i=GetPropIndex(openProp,Constants.FS_BookIsInUse) 
    openProp[i].propVal.ival=Constants.FV_ResetLockAndContinue
    i=GetPropIndex(openProp,Constants.FS_MakeVisible)
    openProp[i].propVal.ival=true
    i=GetPropIndex(openProp,Constants.FS_RefFileNotFound)
    openProp[i].propVal.ival=Constants.FV_AllowAllRefFilesUnFindable
    i=GetPropIndex(openProp,Constants.FS_FileIsOldVersion)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_FileIsStructured)
    openProp[i].propVal.ival=Constants.FV_OpenViewOnly
    i=GetPropIndex(openProp,Constants.FS_OpenFileNotWritable)
    openProp[i].propVal.ival=Constants.FV_DoOK

    retParm = new PropVals()

    docOpen=Open(filename,openProp,retParm);
    //alert(docOpen);
    return docOpen;
}

function OpenBookFiles(bname)
{ 
 //Initialising Current Component
 
 var bookComp=bname.FirstComponentInBook;
 var compId = bookComp.id;
 //Loop for traversing hierarchy of book
 while(compId)
 {   
	var nextId = 0;
	var parentId = 0;
	var compType=bookComp.ComponentType;

    //Assigning next component - If current component  is Group or Folder(move downward in hierarchy)
	if(Constants.FV_BK_FOLDER == compType || Constants.FV_BK_GROUP == compType)
	{  
			var nextComp=bookComp.FirstComponentInBookComponent;
			nextId = nextComp.id;
	}
	//Assigning next component - If current component is not a Group or Folder i.e. a file
	if(nextId == 0)
	{     
		var nextComp = bookComp.NextComponentInBook;
 	   nextId = nextComp.id;
	 }  		 
	//Initialising parent component
	var parentComp = bookComp;
	parentId = parentComp.id;
		
	//Moving upward in hierarchy if reached end of group or folder
	while((nextId == 0) && (parentId != 0))
	{
			parentComp = parentComp.BookComponentParent;
			nextComp = parentComp.NextComponentInBook;
			parentId = parentComp.id;
			nextId = nextComp.id;
	}
         
	//Opening the file
	var fname = bookComp.Name;

         fileId = openfile(fname) // Here openfile function is called

    for (var i=0; i<ShowList[output_no].length; i++)   /*  Calling ShowHide function to Show */
        ShowHide(fileId, ShowList[output_no][i], 1);
    for (var i=0; i<HideList[output_no].length; i++)      /*  Calling ShowHide function to Hide */
        ShowHide(fileId, HideList[output_no][i], 0);
	//Iterating to next component
	bookComp = nextComp ;
	compId = bookComp.id;
 }//end of loop
}

function openfile(filename)
{
    openProp = GetOpenDefaultParams()

    i=GetPropIndex(openProp,Constants.FS_FileIsOldVersion)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_FontChangedMetric)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_FontNotFoundInCatalog)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_FontNotFoundInDoc)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_LanguageNotAvailable)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_LockCantBeReset)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_UpdateTextReferences)
    openProp[i].propVal.ival=Constants.FV_DoNo
    i=GetPropIndex(openProp,Constants.FS_UpdateXRefs)
    openProp[i].propVal.ival=Constants.FV_DoNo
    i=GetPropIndex(openProp,Constants.FS_UseAutoSaveFile)
    openProp[i].propVal.ival=Constants.FV_DoNo
    i=GetPropIndex(openProp,Constants.FS_UseRecoverFile)
    openProp[i].propVal.ival=Constants.FV_DoNo
    i=GetPropIndex(openProp,Constants.FS_AlertUserAboutFailure)
    openProp[i].propVal.ival=false
    i=GetPropIndex(openProp,Constants.FS_BeefyDoc)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_FileIsInUse) 
    openProp[i].propVal.ival=Constants.FV_OpenViewOnly
    i=GetPropIndex(openProp,Constants.FS_MakeVisible)
    openProp[i].propVal.ival=true
    i=GetPropIndex(openProp,Constants.FS_RefFileNotFound)
    openProp[i].propVal.ival=Constants.FV_AllowAllRefFilesUnFindable
    i=GetPropIndex(openProp,Constants.FS_FileIsOldVersion)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_FileIsStructured)
    openProp[i].propVal.ival=Constants.FV_OpenViewOnly
    i=GetPropIndex(openProp,Constants.FS_OpenFileNotWritable)
    openProp[i].propVal.ival=Constants.FV_DoOK

    retParm = new PropVals()
    fileOpen=Open(filename,openProp,retParm);
    
    return fileOpen;
}

function openxml(filename,appname)
{
    openProp = GetOpenDefaultParams()

    i=GetPropIndex(openProp,Constants.FS_FileIsOldVersion)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_OpenAsType)
    openProp[i].propVal.ival=Constants.FV_TYPE_XML
    i=GetPropIndex(openProp,Constants.FS_StructuredOpenApplication) 
    openProp[i].propVal.sval=appname
    i=GetPropIndex(openProp,Constants.FS_FontNotFoundInDoc)
    openProp[i].propVal.ival=Constants.FV_DoOK
    i=GetPropIndex(openProp,Constants.FS_FileIsInUse) 
    openProp[i].propVal.ival=Constants.FV_DoCancel
    i=GetPropIndex(openProp,Constants.FS_AlertUserAboutFailure)
    openProp[i].propVal.ival=Constants.FV_DoCancel

    retParm = new PropVals()
    fileOpen = Open(filename,openProp,retParm);
    return fileOpen;
}
function SavePdf(file,pdfName) 
{	
    var params = GetSaveDefaultParams()
    var returnParamsp =new PropVals()
    var i = GetPropIndex(params, Constants.FS_FileType)
    params[i].propVal.ival =Constants.FV_SaveFmtPdf

    file.Save(pdfName, params, returnParamsp)
    return
}

function CloseAll()
{
    doc=app.FirstOpenDoc
    while(doc.id !=0)
    {
        doc2=doc.NextOpenDocInSession;
        doc.Close(Constants.FF_CLOSE_MODIFIED);
        doc = doc2;   
   }

    book=app.FirstOpenBook
    while(book.id !=0)
    {
        book2=book.NextOpenBookInSession;
        book.Close(Constants.FF_CLOSE_MODIFIED);
        book=book2
	}
}